/*
 * Decompiled with CFR 0.152.
 */
package net.createmod.catnip.gui.element;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import dev.engine_room.flywheel.lib.model.baked.PartialModel;
import dev.engine_room.flywheel.lib.model.baked.SinglePosVirtualBlockGetter;
import javax.annotation.Nullable;
import net.createmod.catnip.client.render.model.BakedModelBufferer;
import net.createmod.catnip.gui.ILightingSettings;
import net.createmod.catnip.gui.UIRenderHelper;
import net.createmod.catnip.gui.element.AbstractRenderElement;
import net.createmod.catnip.impl.client.render.ColoringVertexConsumer;
import net.createmod.catnip.math.VecHelper;
import net.createmod.catnip.platform.CatnipClientServices;
import net.minecraft.class_1087;
import net.minecraft.class_1723;
import net.minecraft.class_1799;
import net.minecraft.class_1920;
import net.minecraft.class_1921;
import net.minecraft.class_1935;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_2404;
import net.minecraft.class_243;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_2960;
import net.minecraft.class_308;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_3611;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_4608;
import net.minecraft.class_4722;
import net.minecraft.class_4770;
import net.minecraft.class_5253;
import net.minecraft.class_776;
import net.minecraft.class_7833;
import net.minecraft.class_811;
import net.minecraft.class_827;
import net.minecraft.class_918;

public class GuiGameElement {
    public static GuiRenderBuilder of(class_1799 stack) {
        return new GuiItemRenderBuilder(stack);
    }

    public static GuiRenderBuilder of(class_1935 itemProvider) {
        return new GuiItemRenderBuilder(itemProvider);
    }

    public static GuiRenderBuilder of(class_2680 state) {
        return new GuiBlockStateRenderBuilder(state);
    }

    public static GuiRenderBuilder of(class_2680 state, class_2586 blockEntity) {
        return new GuiBlockEntityRenderBuilder(state, blockEntity);
    }

    public static GuiRenderBuilder of(class_2586 blockEntity) {
        return GuiGameElement.of(blockEntity.method_11010(), blockEntity);
    }

    public static GuiRenderBuilder of(class_3611 fluid) {
        return new GuiBlockStateRenderBuilder((class_2680)fluid.method_15785().method_15759().method_11657((class_2769)class_2404.field_11278, (Comparable)Integer.valueOf(0)));
    }

    public static GuiRenderBuilder of(PartialModel partial) {
        return new GuiBlockPartialRenderBuilder(partial);
    }

    public static class GuiItemRenderBuilder
    extends GuiRenderBuilder {
        private final class_1799 stack;

        public GuiItemRenderBuilder(class_1799 stack) {
            this.stack = stack;
        }

        public GuiItemRenderBuilder(class_1935 provider) {
            this(new class_1799(provider));
        }

        @Override
        public void render(class_332 graphics) {
            class_4587 poseStack = graphics.method_51448();
            this.prepareMatrix(poseStack);
            this.transformMatrix(poseStack);
            GuiItemRenderBuilder.renderItemIntoGUI(poseStack, this.stack, this.customLighting == null);
            this.cleanUpMatrix(poseStack);
        }

        public static void renderItemIntoGUI(class_4587 poseStack, class_1799 stack, boolean useDefaultLighting) {
            boolean flatLighting;
            class_918 renderer = class_310.method_1551().method_1480();
            class_1087 bakedModel = renderer.method_4019(stack, null, null, 0);
            renderer.field_4729.method_4619(class_1723.field_21668).method_4527(false, false);
            RenderSystem.setShaderTexture((int)0, (class_2960)class_1723.field_21668);
            RenderSystem.enableBlend();
            RenderSystem.enableCull();
            RenderSystem.blendFunc((GlStateManager.class_4535)GlStateManager.class_4535.SRC_ALPHA, (GlStateManager.class_4534)GlStateManager.class_4534.ONE_MINUS_SRC_ALPHA);
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            poseStack.method_22903();
            poseStack.method_46416(0.0f, 0.0f, 100.0f);
            poseStack.method_46416(8.0f, -8.0f, 0.0f);
            poseStack.method_22905(16.0f, 16.0f, 16.0f);
            class_4597.class_4598 buffer = class_310.method_1551().method_22940().method_23000();
            boolean bl = flatLighting = !bakedModel.method_24304();
            if (useDefaultLighting && flatLighting) {
                class_308.method_24210();
            }
            renderer.method_23179(stack, class_811.field_4317, false, poseStack, (class_4597)buffer, 0xF000F0, class_4608.field_21444, bakedModel);
            RenderSystem.disableDepthTest();
            buffer.method_22993();
            RenderSystem.enableDepthTest();
            if (useDefaultLighting && flatLighting) {
                class_308.method_24211();
            }
            poseStack.method_22909();
        }
    }

    public static class GuiBlockStateRenderBuilder
    extends GuiBlockModelRenderBuilder {
        public GuiBlockStateRenderBuilder(class_2680 blockstate) {
            super(class_310.method_1551().method_1541().method_3349(blockstate), blockstate, null);
        }

        @Override
        protected void renderModel(class_776 blockRenderer, class_4597.class_4598 buffer, class_4587 poseStack) {
            if (this.blockState.method_26204() instanceof class_4770) {
                class_308.method_24210();
                super.renderModel(blockRenderer, buffer, poseStack);
                class_308.method_24211();
                return;
            }
            super.renderModel(blockRenderer, buffer, poseStack);
            if (this.blockState.method_26227().method_15769()) {
                return;
            }
            CatnipClientServices.CLIENT_HOOKS.renderFullFluidState(poseStack, buffer, this.blockState.method_26227());
            buffer.method_22993();
        }
    }

    public static class GuiBlockEntityRenderBuilder
    extends GuiBlockModelRenderBuilder {
        public GuiBlockEntityRenderBuilder(class_2680 blockState, class_2586 blockEntity) {
            super(class_310.method_1551().method_1541().method_3349(blockState), blockState, blockEntity);
        }

        @Override
        protected void renderModel(class_776 blockRenderer, class_4597.class_4598 buffer, class_4587 ms) {
            this.renderBlockEntity(blockRenderer, buffer, ms);
            super.renderModel(blockRenderer, buffer, ms);
        }

        private void renderBlockEntity(class_776 blockRenderer, class_4597.class_4598 buffer, class_4587 ms) {
            if (this.blockEntity == null) {
                return;
            }
            class_827 renderer = class_310.method_1551().method_31975().method_3550(this.blockEntity);
            if (renderer == null) {
                return;
            }
            class_2680 stateBefore = this.blockEntity.method_11010();
            this.blockEntity.method_31664(this.blockState);
            renderer.method_3569(this.blockEntity, 0.0f, ms, (class_4597)buffer, 0xF000F0, class_4608.field_21444);
            this.blockEntity.method_31664(stateBefore);
        }
    }

    public static abstract class GuiRenderBuilder
    extends AbstractRenderElement {
        protected double xLocal;
        protected double yLocal;
        protected double zLocal;
        protected double xRot;
        protected double yRot;
        protected double zRot;
        protected double scale = 1.0;
        protected int color = 0xFFFFFF;
        protected class_243 rotationOffset = class_243.field_1353;
        @Nullable
        protected ILightingSettings customLighting = null;

        public GuiRenderBuilder atLocal(double x, double y, double z) {
            this.xLocal = x;
            this.yLocal = y;
            this.zLocal = z;
            return this;
        }

        public GuiRenderBuilder rotate(double xRot, double yRot, double zRot) {
            this.xRot = xRot;
            this.yRot = yRot;
            this.zRot = zRot;
            return this;
        }

        public GuiRenderBuilder rotateBlock(double xRot, double yRot, double zRot) {
            return this.rotate(xRot, yRot, zRot).withRotationOffset(VecHelper.getCenterOf((class_2382)class_2338.field_10980));
        }

        public GuiRenderBuilder scale(double scale) {
            this.scale = scale;
            return this;
        }

        public GuiRenderBuilder color(int color) {
            this.color = color;
            return this;
        }

        public GuiRenderBuilder withRotationOffset(class_243 offset) {
            this.rotationOffset = offset;
            return this;
        }

        public GuiRenderBuilder lighting(ILightingSettings lighting) {
            this.customLighting = lighting;
            return this;
        }

        protected void prepareMatrix(class_4587 poseStack) {
            poseStack.method_22903();
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            RenderSystem.enableDepthTest();
            RenderSystem.enableBlend();
            RenderSystem.blendFunc((GlStateManager.class_4535)GlStateManager.class_4535.SRC_ALPHA, (GlStateManager.class_4534)GlStateManager.class_4534.ONE_MINUS_SRC_ALPHA);
            this.prepareLighting(poseStack);
        }

        protected void transformMatrix(class_4587 poseStack) {
            poseStack.method_46416(this.x, this.y, this.z);
            poseStack.method_22905((float)this.scale, (float)this.scale, (float)this.scale);
            poseStack.method_22904(this.xLocal, this.yLocal, this.zLocal);
            UIRenderHelper.flipForGuiRender(poseStack);
            poseStack.method_22904(this.rotationOffset.field_1352, this.rotationOffset.field_1351, this.rotationOffset.field_1350);
            poseStack.method_22907(class_7833.field_40718.rotationDegrees((float)this.zRot));
            poseStack.method_22907(class_7833.field_40714.rotationDegrees((float)this.xRot));
            poseStack.method_22907(class_7833.field_40716.rotationDegrees((float)this.yRot));
            poseStack.method_22904(-this.rotationOffset.field_1352, -this.rotationOffset.field_1351, -this.rotationOffset.field_1350);
        }

        protected void cleanUpMatrix(class_4587 poseStack) {
            poseStack.method_22909();
            this.cleanUpLighting(poseStack);
        }

        protected void prepareLighting(class_4587 poseStack) {
            if (this.customLighting != null) {
                this.customLighting.applyLighting();
            } else {
                class_308.method_24211();
            }
        }

        protected void cleanUpLighting(class_4587 poseStack) {
            if (this.customLighting != null) {
                class_308.method_24211();
            }
        }
    }

    public static class GuiBlockPartialRenderBuilder
    extends GuiBlockModelRenderBuilder {
        public GuiBlockPartialRenderBuilder(PartialModel partial) {
            super(partial.get(), null, null);
        }
    }

    protected static class GuiBlockModelRenderBuilder
    extends GuiRenderBuilder {
        protected class_1087 blockModel;
        protected class_2680 blockState;
        @Nullable
        protected class_2586 blockEntity;

        public GuiBlockModelRenderBuilder(class_1087 blockmodel, @Nullable class_2680 blockState, @Nullable class_2586 blockEntity) {
            this.blockState = blockState == null ? class_2246.field_10124.method_9564() : blockState;
            this.blockModel = blockmodel;
            this.blockEntity = blockEntity;
        }

        @Override
        public void render(class_332 graphics) {
            class_4587 poseStack = graphics.method_51448();
            this.prepareMatrix(poseStack);
            class_310 mc = class_310.method_1551();
            class_776 blockRenderer = mc.method_1541();
            class_4597.class_4598 buffer = graphics.method_51450();
            this.transformMatrix(poseStack);
            RenderSystem.setShaderTexture((int)0, (class_2960)class_1723.field_21668);
            this.renderModel(blockRenderer, buffer, poseStack);
            this.cleanUpMatrix(poseStack);
        }

        protected void renderModel(class_776 blockRenderer, class_4597.class_4598 buffer, class_4587 ms) {
            SinglePosVirtualBlockGetter level = SinglePosVirtualBlockGetter.createFullBright();
            level.blockState(this.blockState);
            level.blockEntity(this.blockEntity);
            BakedModelBufferer.bufferModel(this.blockModel, class_2338.field_10980, (class_1920)level, this.blockState, ms, (layer, shade) -> {
                layer = layer == class_1921.method_23583() ? class_4722.method_24076() : class_4722.method_24074();
                return new ColoringVertexConsumer(buffer.getBuffer(layer), (float)class_5253.class_5254.method_27765((int)this.color) / 255.0f, (float)class_5253.class_5254.method_27766((int)this.color) / 255.0f, (float)class_5253.class_5254.method_27767((int)this.color) / 255.0f, 1.0f);
            });
            buffer.method_22993();
        }
    }
}

